<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePollActionLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('poll_action_log', function (Blueprint $table) {
            $table->bigIncrements('PA_Sr');
            $table->unsignedBigInteger('Poll_Id'); // Foreign key to PollBook
            $table->unsignedBigInteger('U_ID'); // Foreign key to UserMaster
            $table->unsignedBigInteger('PA_Id'); // Foreign key to PollAction
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('Poll_Id')->references('Poll_Id')->on('poll_book')->onDelete('cascade');
            $table->foreign('U_ID')->references('U_Id')->on('users_master')->onDelete('cascade');
            $table->foreign('PA_Id')->references('PA_Id')->on('poll_action')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('poll_action_log');
    }
}
