<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePollActionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('poll_action', function (Blueprint $table) {
            $table->bigIncrements('PA_Id');
            $table->string('PA_Desc', 500);
            $table->unsignedBigInteger('Poll_Id'); // Foreign key to PollBook
            $table->unsignedBigInteger('PA_Sr');
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('Poll_Id')->references('Poll_Id')->on('poll_book')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('poll_action');
    }
}
