<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePollBookTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('poll_book', function (Blueprint $table) {
            $table->bigIncrements('Poll_Id');
            $table->unsignedBigInteger('Pc_ID'); // Foreign key to PollCategory
            $table->unsignedBigInteger('SocId'); // Foreign key to Society
            $table->unsignedBigInteger('U_Id'); // Foreign key to Users
            $table->string('Title', 255);
            $table->string('Description', 500);
            $table->string('PollType', 1);
            $table->string('Severity', 1);
            $table->string('Status', 1);
            $table->dateTime('STDate');
            $table->dateTime('EdDate');
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('Pc_ID')->references('Pc_ID')->on('poll_category')->onDelete('cascade');
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('poll_book');
    }
}
