<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pb_allotments', function (Blueprint $table) {
            $table->bigIncrements('PBU_ID');
            $table->unsignedBigInteger('PB_ID');
            $table->string('Status', 1)->nullable();
            $table->date('ActiveDate');
            $table->date('ValidDate')->nullable();
            $table->unsignedBigInteger('SU_ID');
            $table->unsignedBigInteger('Fees_Id');
            $table->unsignedBigInteger('Asgn_By');
            $table->timestamps();

            $table->foreign('PB_ID')->references('PB_ID')->on('pb_units')->onDelete('restrict');
            $table->foreign('SU_ID')->references('SU_ID')->on('soc_units')->onDelete('restrict');
            $table->foreign('Fees_Id')->references('FC_Id')->on('fees_config')->onDelete('restrict');
            $table->foreign('Asgn_By')->references('U_Id')->on('users_master')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pb_allotments');
    }
};
