<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pb_units', function (Blueprint $table) {
            $table->bigIncrements('PB_ID');
            $table->unsignedBigInteger('PBT_ID');
            $table->string('PB_NO', 5)->nullable();
            $table->timestamps();

            $table->foreign('PBT_ID')->references('PBT_ID')->on('pb_types')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pb_units');
    }
};
