<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pb_types', function (Blueprint $table) {
            $table->bigIncrements('PBT_ID');
            $table->string('Post_Box_Desc', 25);
            $table->unsignedBigInteger('SocId');
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pb_types');
    }
};
