<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('locker_allotments', function (Blueprint $table) {
            $table->bigIncrements('LsU_Id');
            $table->unsignedBigInteger('LS_ID');
            $table->string('Status', 1);
            $table->dateTime('ActiveDate');
            $table->dateTime('ValidDate')->nullable();
            $table->unsignedBigInteger('SU_ID');
            $table->unsignedBigInteger('FC_Id');
            $table->unsignedBigInteger('Asgn_By');
            $table->timestamps();

            $table->foreign('LS_ID')->references('LS_ID')->on('locker_units')->onDelete('restrict');
            $table->foreign('SU_ID')->references('SU_ID')->on('soc_units')->onDelete('restrict');
            $table->foreign('FC_Id')->references('FC_Id')->on('fees_config')->onDelete('restrict');
            $table->foreign('Asgn_By')->references('U_Id')->on('users_master')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('locker_allotments');
    }
};
