<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('locker_types', function (Blueprint $table) {
            $table->bigIncrements('Lk_Id');
            $table->string('Locker_Desc', 25);
            $table->unsignedBigInteger('SocId');
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('locker_types');
    }
};
