<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('fees_config', function (Blueprint $table) {
            $table->bigIncrements('FC_Id');
            $table->unsignedBigInteger('Fs_Id');
            $table->unsignedBigInteger('SocId');
            $table->date('Start_Date');
            $table->string('Status', 1);
            $table->unsignedInteger('Amount');
            $table->string('Frequency', 50);
            $table->unsignedInteger('EB_Disc')->nullable();
            $table->string('EB_Days', 50)->nullable();
            $table->unsignedInteger('Blk_Payment')->nullable();
            $table->unsignedInteger('Blk_Units')->nullable();
            $table->string('Spl_Cate', 1);
            $table->unsignedInteger('Late_Charges')->nullable();
            $table->unsignedInteger('Interest_Charges')->nullable();
            $table->string('Int_Chg_Unit', 10)->nullable();
            $table->timestamps();

            $table->foreign('Fs_Id')->references('Fs_Id')->on('fees_master')->onDelete('restrict');
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fees_config');
    }
};
