<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('unit_members_link', function (Blueprint $table) {
            $table->bigIncrements('SUM_Id');
            $table->unsignedBigInteger('SU_ID')->nullable();
            $table->unsignedBigInteger('U_Id')->nullable();
            $table->string('Status', 1)->nullable();
            $table->dateTime('Reg_Date')->nullable();
            $table->string('EntryConfirm', 1)->nullable();
            $table->string('Spl_Category', 1)->nullable();
            $table->timestamps();

            $table->foreign('SU_ID')->references('SU_ID')->on('soc_units')->onDelete('restrict');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('unit_members_link');
    }
};
