<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('society_committee', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('SCM_Id');
            $table->unsignedBigInteger('SocId')->nullable();
            $table->unsignedBigInteger('MemDesi_ID')->nullable();
            $table->unsignedBigInteger('U_Id')->nullable();
            $table->dateTime('Desi_St_Date')->nullable();
            $table->dateTime('Desi_Ed_Date')->nullable();
            $table->string('Status', 1)->nullable();
            $table->unsignedBigInteger('SR_Id')->nullable();
            $table->string('Comt_Type', 1)->nullable();
            $table->unsignedBigInteger('SB_Id')->nullable();
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
            $table->foreign('MemDesi_ID')->references('MemDesi_ID')->on('com_desi')->onDelete('restrict');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('restrict');
            $table->foreign('SR_Id')->references('SR_Id')->on('soci_reso_books')->onDelete('restrict');
            $table->foreign('SB_Id')->references('SB_Id')->on('soc_block')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('society_committee');
    }
};
