<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('soci_reso_books', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('SR_Id');
            $table->unsignedBigInteger('SocId')->nullable();
            $table->string('Sr_Subject', 25)->nullable();
            $table->dateTime('Sr_Date')->nullable();
            $table->string('Sr_Place', 25)->nullable();
            $table->dateTime('Sr_Time')->nullable();
            $table->string('Sr_Description', 25)->nullable();
            $table->string('Sr_File', 25)->nullable();
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('soci_reso_books');
    }
};
