<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('com_desi', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('MemDesi_ID');
            $table->string('MemDesi_Name', 50)->nullable();
            $table->string('SericeAreas', 50)->nullable();
            $table->timestamps();

            $table->unique('MemDesi_Name', 'com_desi_name_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('com_desi');
    }
};
