<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('soc_units', function (Blueprint $table) {
            $table->bigIncrements('SU_ID');
            $table->unsignedBigInteger('SB_Id')->nullable();
            $table->unsignedBigInteger('UT_Id')->nullable();
            $table->integer('Unit_No')->nullable();
            $table->timestamps();

            $table->foreign('SB_Id')->references('SB_Id')->on('soc_block')->onDelete('restrict');
            $table->foreign('UT_Id')->references('UT_Id')->on('unit_types')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('soc_units');
    }
};
