<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('unit_types', function (Blueprint $table) {
            $table->bigIncrements('UT_Id');
            $table->string('UT_Name', 10)->nullable();
            $table->bigInteger('UT_Size')->nullable();
            $table->string('SizeUnit', 1)->nullable();
            $table->timestamps();

            $table->unique('UT_Name', 'unit_type_name_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('unit_types');
    }
};
