<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('soc_block', function (Blueprint $table) {
            $table->bigIncrements('SB_Id');
            $table->string('SB_Name', 25);
            $table->unsignedBigInteger('Sd_Id');
            $table->timestamps();

            $table->foreign('Sd_Id')->references('Sd_Id')->on('soci_divisions')->onDelete('restrict');
            $table->unique(['SB_Name', 'Sd_Id'], 'soc_block_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('soc_block');
    }
};
