<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('soci_divisions', function (Blueprint $table) {
            $table->bigIncrements('Sd_Id');
            $table->string('Sd_Name', 25);
            $table->unsignedBigInteger('SocId');
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
            $table->unique(['Sd_Name', 'SocId'], 'soci_division_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('soci_divisions');
    }
};
