<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('society_master', function (Blueprint $table) {
            $table->bigIncrements('SocId');
            $table->string('SocName', 25);
            $table->string('Address', 35);
            $table->string('City', 8);
            $table->unsignedBigInteger('PinNo');
            $table->string('SocURL', 1);
            $table->string('Status', 1);
            $table->date('RegiDate');
            $table->string('RegiNumber', 25);
            $table->string('PhoneNo', 10)->nullable();
            $table->string('Email', 255)->nullable();
            $table->string('Website', 255)->nullable();
            $table->date('Enrl_Date')->nullable();
            $table->unsignedBigInteger('St_Id');
            $table->string('Short_Code', 6)->unique();
            $table->timestamps();

            $table->foreign('St_Id')->references('St_Id')->on('soci_type')->onDelete('restrict');
            $table->unique('RegiNumber', 'society_regi_number_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('society_master');
    }
};
