<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users_master', function (Blueprint $table) {
            $table->id('U_Id'); // Primary Key
            $table->string('U_Name', 50);
            $table->string('U_Email', 35);
            $table->string('U_Password', 255);
            $table->string('U_Status', 1)->nullable(); // Nullable field
            $table->string('U_Gender', 1)->nullable(); // Nullable field
            $table->string('U_Mobile', 10);
            $table->date('U_DOB')->nullable(); // Nullable field
            $table->string('U_Image', 255)->nullable();

            $table->timestamps(); // Created & Updated timestamp columns
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users_master');
    }
};
