<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VisitorRegister extends Model
{
    use HasFactory;

    protected $table = 'visitor_register';
    protected $primaryKey = 'VR_Id';
    public $incrementing = true;

    protected $fillable = [
        'SocId',
        'Vr_RegDate',
        'Vr_Name',
        'Vr_Co_Name',
        'VT_Id',
        'VrU_Id',
        'Visit_Mode',
        'Vr_Purpose',
        'VR_Vehicle',
        'Vr_StDate',
        'Vr_EdDate',
        'Vr_Apr_Stt',
        'Vr_Apr_By',
        'Vr_Ent_DT',
        'Vr_Est_Tm',
        'Vr_Ext_DT',
        'Vr_Ent_Gt',
        'Vr_Ext_Gt',
        'Vr_Noof_Vst',
        'Vr_In_Pic',
        'Vr_Out_Pic',
        'Vr_End_Qr',
        'Vr_Exit_Qr',
        'OTP',
        'Vr_Status'
    ];

    protected $casts = [
        'Vr_RegDate' => 'date:Y-m-d',
        'Vr_StDate' => 'date:Y-m-d',
        'Vr_EdDate' => 'date:Y-m-d',
        'Vr_Ent_DT' => 'datetime:H:i:s',
        'Vr_Est_Tm' => 'datetime:H:i:s',
        'Vr_Ext_DT' => 'datetime:H:i:s',
        'Vr_In_Pic' => 'array',
        'Vr_Out_Pic' => 'array',
    ];

    /**
     * Define relationship with SocietyMaster.
     */
    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    /**
     * Define relationship with VisitorType.
     */
    public function visitorType()
    {
        return $this->belongsTo(VisitorType::class, 'VT_Id', 'VT_Id');
    }

    /**
     * Define relationship with UserMaster (visitor's user).
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'VrU_Id', 'U_Id');
    }

    /**
     * Define relationship with UserMaster (approver).
     */
    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'Vr_Apr_By', 'U_Id');
    }

    /**
     * Define relationship with GateMaster (entry gate).
     */
    public function entryGate()
    {
        return $this->belongsTo(GateMaster::class, 'Vr_Ent_Gt', 'GM_ID');
    }

    /**
     * Define relationship with GateMaster (exit gate).
     */
    public function exitGate()
    {
        return $this->belongsTo(GateMaster::class, 'Vr_Ext_Gt', 'GM_ID');
    }
}
