<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VehicleMaster extends Model
{
    use HasFactory;

    protected $table = 'vehicles'; // Corrected to match the actual table name
    protected $primaryKey = 'Vehicle_Id';
    public $timestamps = false;

    protected $fillable = [
        'SU_Id',
        'SocId',
        'SCP_Id', // Added
        'VehicleRegNo',
        'Status',
        'ActiveDate', // Added
        'Vehicle_Type',
        'Vehicle_Model',
        'Vehicle_Brand',
        'Vehicle_Img',
        'CreatedAt', // Added to match schema
    ];

    protected $casts = [
        'Status' => 'string', // For enum
        'ActiveDate' => 'datetime', // Added for timestamp
        'CreatedAt' => 'datetime', // Added for timestamp
    ];

    // Relationships
    public function unit()
    {
        return $this->belongsTo(SocUnit::class, 'SU_Id', 'SU_ID')
            ->with(['socBlock.sociDivision']);
    }

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }



    public function parkingMaster()
    {
        return $this->belongsTo(ParkingMaster::class, 'SCP_Id', 'SCP_Id');
    }
}
