<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;

class User extends Model
{
    use HasFactory, HasApiTokens;

    protected $table = 'users_master';
    protected $primaryKey = 'U_Id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'U_Name',
        'U_Email',
        'U_Password',
        'U_Status',
        'U_Gender',
        'U_Mobile',
        'U_DOB',
        'U_Image',
        'SocId', // Already included
    ];

    // protected $hidden = [
    //     'U_Password',
    // ];

    protected $casts = [
        'U_DOB' => 'date:Y-m-d',
    ];

    public function roleMappings()
    {
        return $this->hasMany(RoleMapping::class, 'U_Id', 'U_Id');
    }

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }
}
