<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UnitType extends Model
{
    use HasFactory;

    protected $table = 'unit_types';
    protected $primaryKey = 'UT_Id';
    public $timestamps = true;

    protected $fillable = [
        'UT_Name',
        'UT_Size',
        'SizeUnit',
        'SocId',
    ];

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }
}
