<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class UnitMemLink extends Model
{
    protected $table = 'unit_members_link';
    protected $primaryKey = 'SUM_Id';
    public $timestamps = true;

    protected $fillable = [
        'SocId',
        'SU_ID',
        'U_Id',
        'Status',
        'Reg_Date',
        'EntryConfirm',
        'Spl_Category',
        'Us_Admin',
        'MemRel_Id',
        'PrivecyMode',
    ];

    protected $casts = [
        'Reg_Date' => 'datetime',
    ];

    // Accessor for Reg_Date as dd/mm/yyyy
    public function getRegDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d/m/Y') : null;
    }

    // Mutator for Reg_Date to accept dd/mm/yyyy
    public function setRegDateAttribute($value)
    {
        $this->attributes['Reg_Date'] = $value
            ? Carbon::createFromFormat('d/m/Y', $value)->startOfDay()
            : null;
    }

    public function unit()
    {
        return $this->belongsTo(SocUnit::class, 'SU_ID', 'SU_ID');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function relation()
    {
        return $this->belongsTo(RelationMaster::class, 'MemRel_Id', 'MemRel_Id');
    }
}
