<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubFinanTrn extends Model
{
    use HasFactory;

    protected $table = 'sub_finan_trns';
    protected $primaryKey = 'Sft_Id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = false;

    protected $fillable = [
        'Co_Id',
        'Br_Id',
        'Ft_Id',
        'vou_ty',
        'vou_id',
        'vou_sr',
        'vou_ln',
        'sub_sr_no',
        'inst_no',
        'agt_amt',
        'chq_no',
        'pymt_dt',
        'op_id',
        'dt_tm',
        'ag_id',
        'in_no',
        'inq_id',
        'chq_ret',
        'loan_incom',
    ];

    protected $casts = [
        'pymt_dt' => 'datetime',
        'inst_no' => 'decimal:0',
        'agt_amt' => 'decimal:4',
        'in_no' => 'decimal:0',
        'chq_ret' => 'decimal:2',
        'loan_incom' => 'decimal:2',
    ];

    // Relationships
    public function finanTrn()
    {
        return $this->belongsTo(FinanTrn::class, 'Ft_Id', 'Ft_Id');
    }

    public function coMaster()
    {
        return $this->belongsTo(CoMaster::class, 'Co_Id', 'Co_Id');
    }

    public function branchM()
    {
        return $this->belongsTo(BranchM::class, 'Br_Id', 'Br_Id');
    }
}
