<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SocietyMaster extends Model
{
    use HasFactory;

    protected $table = 'society_master';
    protected $primaryKey = 'SocId';
    public $timestamps = true;

    protected $fillable = [
        'SocName',
        'Soc_Sr_Name',
        'Address',
        'City',
        'State',
        'Country',
        'PinNo',
        'SocURL',
        'Status',
        'RegiDate',
        'RegiNumber',
        'PhoneNo',
        'Email',
        'password', // Changed to lowercase to match database column
        'Website',
        'Enrl_Date',
        'St_Id',
        'Short_Code',
    ];

    protected $hidden = [
        'password', // Hide password field in responses
    ];



    protected $casts = [
        'RegiDate' => 'date:d/m/Y',
        'Enrl_Date' => 'date:d/m/Y',
    ];

    public function societyType()
    {
        return $this->belongsTo(SociType::class, 'St_Id', 'St_Id');
    }
}
