<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SocietyCommittee extends Model
{
    use HasFactory;

    protected $table = 'society_committee';
    protected $primaryKey = 'SCM_Id';
    public $timestamps = true;

    protected $fillable = [
        'SocId',
        'MemDesi_ID',
        'U_Id',
        'Desi_St_Date',
        'Desi_Ed_Date',
        'Status',
        'SR_Id',
        'Comt_Type',
        'SB_Id',
    ];
    

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function designation()
    {
        return $this->belongsTo(ComDesi::class, 'MemDesi_ID', 'MemDesi_ID');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }

    public function resolution()
    {
        return $this->belongsTo(SociResoBook::class, 'SR_Id', 'SR_Id');
    }

    public function block()
    {
        return $this->belongsTo(SocBlock::class, 'SB_Id', 'SB_Id');
    }
}
