<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SociResoBook extends Model
{
    protected $table = 'soci_reso_books';
    protected $primaryKey = 'SR_Id';
    public $timestamps = true;

    protected $fillable = [
        'SocId',
        'Sr_Subject',
        'Sr_Date',
        'Sr_Place',
        'Sr_Time',
        'Sr_Description',
        'Sr_File'
    ];

    /**
     * Relationship: SociResoBook belongs to a SocietyMaster.
     */
    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    /**
     * Optional: Relationship: SociResoBook has many FreelancerRegister records.
     */
    
}
