<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SociDivision extends Model
{
    use HasFactory;

    protected $table = 'soci_divisions';
    protected $primaryKey = 'Sd_Id';
    public $timestamps = true;

    protected $fillable = [
        'Sd_Name',
        'SocId',
    ];

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function blocks()
    {
        return $this->hasMany(SocBlock::class, 'Sd_Id', 'Sd_Id');
    }
}
