<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SecurityAgency extends Model
{
    use HasFactory;

    protected $table = 'security_agencies';
    protected $primaryKey = 'SA_Id';
    protected $fillable = [
        'SocId', 'U_Id', 'SR_Id', 'BusinessName', 'Registration',
        'TaxRegistration', 'STDate', 'EdDate', 'Status'
    ];

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }

    public function resourceBook()
    {
        return $this->belongsTo(SociResoBook::class, 'SR_Id', 'SR_Id');
    }
}
