<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ScoPackage extends Model
{
    use HasFactory;

    protected $primaryKey = 'ScoPck_Id';

    protected $fillable = [
        'SocId',
        'PackageId',
        'Start_Date',
        'Valid_Date',
        'Status',
    ];

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function package()
    {
        return $this->belongsTo(PackageMaster::class, 'PackageId', 'PackageId');
    }
}
