<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ScoDiscMap extends Model
{
    use HasFactory;

    protected $primaryKey = 'ScoDisID';

    protected $fillable = [
        'SocId',
        'DiscID',
        'Start_Date',
        'Valid_Date',
        'Status',
    ];

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function discount()
    {
        return $this->belongsTo(DiscountMaster::class, 'DiscID', 'DiscID');
    }
}
