<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RoleMapping extends Model
{
    use HasFactory;

    protected $table = 'role_mapping';
    protected $primaryKey = 'URoleMap';
    public $timestamps = true;

    protected $fillable = [
        'U_Id',
        'Role_Id',
        'Default_Rid',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }

    public function role()
    {
        return $this->belongsTo(RoleMaster::class, 'Role_Id', 'Role_Id');
    }
}
