<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PollBook extends Model
{
    use HasFactory;

    protected $table = 'poll_book'; // Define the table name
    protected $primaryKey = 'Poll_Id'; // Define the primary key
    protected $fillable = ['Pc_ID', 'SocId', 'U_Id', 'Title', 'Description', 'PollType', 'Severity', 'Status', 'STDate', 'EdDate']; // Define fillable fields

    // Define relationships
    public function pollCategory()
    {
        return $this->belongsTo(PollCategory::class, 'Pc_ID', 'Pc_ID');
    }

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }
}
