<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PollActionLog extends Model
{
    use HasFactory;

    protected $table = 'poll_action_log'; // Define the table name
    protected $primaryKey = 'PA_Sr';  // Define the primary key
    protected $fillable = ['Poll_Id', 'U_ID', 'PA_Id']; // Define fillable fields

    // Define relationships
    public function pollBook()
    {
        return $this->belongsTo(PollBook::class, 'Poll_Id', 'Poll_Id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_ID', 'U_Id');
    }

    public function pollAction()
    {
        return $this->belongsTo(PollAction::class, 'PA_Id', 'PA_Id');
    }
}
