<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PollAction extends Model
{
    use HasFactory;

    protected $table = 'poll_action'; // Define the table name
    protected $primaryKey = 'PA_Id';  // Define the primary key
    protected $fillable = ['PA_Desc', 'Poll_Id', 'PA_Sr']; // Define fillable fields

    // Define relationships
    public function pollBook()
    {
        return $this->belongsTo(PollBook::class, 'Poll_Id', 'Poll_Id');
    }
}
