<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParkingMaster extends Model
{
    use HasFactory;

    protected $table = 'parking_masters';
    protected $primaryKey = 'SCP_Id';

    protected $fillable = [
        'SCP_Desc',
        'Status',
        'ActiveDate',
        'ValidDate',
        'SR_Id',
        'PS_ID',
        'SU_ID',
        'Asgn_By',
    ];

    protected $casts = [
        'ActiveDate' => 'datetime',
        'ValidDate' => 'datetime',
        'Status' => 'string',
    ];

    // Relationships
    public function sociResoBook()
    {
        return $this->belongsTo(SociResoBook::class, 'SR_Id', 'SR_Id');
    }

    public function parkingSlot()
    {
        return $this->belongsTo(ParkingSlot::class, 'PS_ID', 'PS_ID');
    }

    public function socUnit()
    {
        return $this->belongsTo(SocUnit::class, 'SU_ID', 'SU_ID');
    }

    public function assignedBy()
    {
        return $this->belongsTo(User::class, 'Asgn_By', 'U_Id');
    }
}
