<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageModuleLink extends Model
{
    use HasFactory;

    protected $primaryKey = 'PMLinkID';

    protected $fillable = [
        'PackageId',
        'ModuleID',
        'ModuleFixPrice',
        'ModuleFreeUsers',
        'ExtraUserFees',
        'MarginShare',
    ];

    public function package()
    {
        return $this->belongsTo(PackageMaster::class, 'PackageId', 'PackageId');
    }

    public function module()
    {
        return $this->belongsTo(ModuleMaster::class, 'ModuleID', 'ModuleID');
    }
}
