<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NoticeGallary extends Model
{
    use HasFactory;

    protected $table = 'notice_gallary';
    protected $primaryKey = 'Ntg_Id';

    protected $fillable = [
        'Ntc_Id',
        'Image',
        'Img_Date',
        'Img_Status',
    ];

    // Define relationships
    public function noticeBoard()
    {
        return $this->belongsTo(NoticeBoard::class, 'Ntc_Id', 'Ntc_Id');
    }

}
