<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NoticeBoard extends Model
{
    use HasFactory;

    protected $table = 'notice_board'; // Define the table name
    protected $primaryKey = 'Ntc_Id';  // Define the primary key
    protected $fillable = [
        'Nc_Id',
        'Title',
        'Description',
        'SocId',
        'Severity',
        'Status',
        'STDate',
        'EdDate',
        'Added_by',
        'Notice_type',
        'Press_by'
    ]; // Define fillable fields

    // Define relationships
    public function noticeCategory()
    {
        return $this->belongsTo(NoticeCategory::class, 'Nc_Id', 'Nc_Id');
    }

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'Added_by', 'U_Id');
    }
}
