<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NoticeActionLog extends Model
{
    use HasFactory;

    protected $table = 'notice_action_log'; // Table name
    protected $primaryKey = 'NA_Sr'; // Primary key
    protected $fillable = ['Ntc_Id', 'U_Id', 'NA_Id']; // Fillable fields

    // Define relationships
    public function noticeBoard()
    {
        return $this->belongsTo(NoticeBoard::class, 'Ntc_Id', 'Ntc_Id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }

    public function noticeAction()
    {
        return $this->belongsTo(NoticeAction::class, 'NA_Id', 'NA_Id');
    }
}
