<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingInvitee extends Model
{
    use HasFactory;

    protected $table = 'meeting_invitees'; // Define the table name
    protected $primaryKey = 'MI_Id'; // Define the primary key
    protected $fillable = ['MB_Id', 'U_Id', 'InviteSend', 'InviteRead', 'Attend']; // Define fillable fields

    // Define relationships
    public function meetingBook()
    {
        return $this->belongsTo(MeetingBook::class, 'MB_Id', 'MB_Id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }
}
