<?php
// app/Models/MeetingBook.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingBook extends Model
{
    use HasFactory;

    protected $table = 'meeting_book'; // Specify the table name
    protected $primaryKey = 'MB_Id'; // Specify the primary key column
    protected $fillable = [
        'SocId',
        'Venue',
        'Agenda',
        'STDate',
        'StTime',
        'EdTime',
        'Status',
        'Meeting_Doc',
    ];  // Specify fillable fields

    // Cast Meeting_Doc as an array
    protected $casts = [
        'Meeting_Doc' => 'array',
    ];

    // Define relationships
    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }
}
