<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class LockerAllotment extends Model
{
    protected $table = 'locker_allotments';
    protected $primaryKey = 'LsU_Id';
    public $timestamps = true;

    protected $fillable = [
        'LS_ID',
        'Status',
        'ActiveDate',
        'ValidDate',
        'SU_ID',
        'FC_Id',
        'Asgn_By',
    ];

    protected $casts = [
        'ActiveDate' => 'date:Y-m-d',
        'ValidDate' => 'date:Y-m-d',
    ];

    // Accessor for ActiveDate as dd/mm/yyyy
    public function getActiveDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d/m/Y') : null;
    }

    // Mutator for ActiveDate to accept dd/mm/yyyy
    public function setActiveDateAttribute($value)
    {
        $this->attributes['ActiveDate'] = $value
            ? Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d')
            : null;
    }

    // Accessor for ValidDate as dd/mm/yyyy
    public function getValidDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d/m/Y') : null;
    }

    // Mutator for ValidDate to accept dd/mm/yyyy
    public function setValidDateAttribute($value)
    {
        $this->attributes['ValidDate'] = $value
            ? Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d')
            : null;
    }

    public function lockerUnit()
    {
        return $this->belongsTo(LockerUnit::class, 'LS_ID', 'LS_ID');
    }

    public function societyUnit()
    {
        return $this->belongsTo(SocUnit::class, 'SU_ID', 'SU_ID');
    }

    public function feeConfig()
    {
        return $this->belongsTo(FeeConfig::class, 'FC_Id', 'FC_Id');
    }

    public function assignedBy()
    {
        return $this->belongsTo(User::class, 'Asgn_By', 'U_Id');
    }
}
