<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LedgGrp extends Model
{
    use HasFactory;

    protected $table = 'ledg_grps';
    protected $primaryKey = 'Gr_Id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = false;

    protected $fillable = [
        'Co_Id',
        'gr_code',
        'up_gr',
        'gr_nm',
        'gr_sr',
        'gr_alt',
        'gr_stt',
        'gr_al_c',
        'GIFI_Code', // Added new field
        'is_del',
        'gr_exp',
        'gr_buk',
        'gr_prt',
        'op_id',
        'dt_tm',
        'naof_grp',
        'credition',
        'eff_gp',
        'eff_sub_led',
    ];

    protected $casts = [
        'gr_sr' => 'decimal:0',
        'gr_stt' => 'decimal:0',
    ];

    // Relationships
    public function coMaster()
    {
        return $this->belongsTo(CoMaster::class, 'Co_Id', 'Co_Id');
    }
}
