<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GuardRegistration extends Model
{
    use HasFactory;

    protected $table = 'guard_registration';
    protected $primaryKey = 'GR_Id';

    protected $fillable = ['SA_Id', 'U_Id', 'GC_Id'];

    public function securityAgency()
    {
        return $this->belongsTo(SecurityAgency::class, 'SA_Id', 'SA_Id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }

    public function guardCategory()
    {
        return $this->belongsTo(GuardCategory::class, 'GC_Id', 'GC_Id');
    }
}
