<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GuardDutyRegister extends Model
{
    use HasFactory;

    protected $table = 'guard_duty_register';
    protected $primaryKey = 'GD_Id';
    protected $fillable = ['GR_Id', 'DutyOn', 'DutyOff', 'DP_Id', 'Status', 'DutyType'];

    public function guardRegistration()
    {
        return $this->belongsTo(GuardRegistration::class, 'GR_Id', 'GR_Id');
    }

    public function dutyPoint()
    {
        return $this->belongsTo(DutyPoint::class, 'DP_Id', 'DP_Id');
    }
}
