<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FreeLServLink extends Model
{
    use HasFactory;

    protected $table = 'free_l_serv_link';
    protected $primaryKey = 'FLSr_ID';
    protected $fillable = ['Srv_Id', 'FL_Id', 'ListPriority'];

    public function serviceCategory()
    {
        return $this->belongsTo(ServiceCategory::class, 'Srv_Id', 'srv_id');
    }

    public function freelancerRegister()
    {
        return $this->belongsTo(FreelancerRegister::class, 'FL_Id', 'FL_Id');
    }
}
