<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FreeLRating extends Model
{
    use HasFactory;

    protected $table = 'free_l_rating';
    protected $primaryKey = 'FLR_Id';
    protected $fillable = ['FL_Id', 'U_Id', 'Status'];

    public function freelancerRegister()
    {
        return $this->belongsTo(FreelancerRegister::class, 'FL_Id', 'FL_Id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }
}
