<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class FinanTrn extends Model
{
    use HasFactory;

    protected $table = 'finan_trns';
    protected $primaryKey = 'Ft_Id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = false;

    protected $fillable = [
        'Co_Id',
        'Br_Id',
        'Pr_Id',
        'vou_ty',
        'vou_id',
        'vou_sr',
        'vou_ln',
        'v_mode',
        'vou_rf',
        'vou_dt',
        'inq_id',
        'ag_id',
        'inst_no',
        'agt_amt',
        'cr_amt',
        'dr_amt',
        'ref_id',
        'chq_no',
        'chq_dt',
        'clr_dt',
        'bk_id',
        'lot_no',
        'rmk1',
        'rmk2',
        'rmk3',
        'rmk4',
        'rmk5',
        'chq_mode',
        'r_mode',
        'sms_stus',
        'email_stus',
        'sm_id',
        'an_id',
        'bfr1',
        'bfr2',
        'op_id',
        'dt_tm',
        'pay_mode',
        'exp_ref',
    ];

    protected $casts = [
        'vou_dt' => 'datetime',
        'chq_dt' => 'datetime',
        'clr_dt' => 'datetime',
        'inq_id' => 'decimal:0',
        'agt_amt' => 'decimal:4',
        'cr_amt' => 'decimal:2',
        'dr_amt' => 'decimal:2',
        'ref_id' => 'decimal:0',
        'lot_no' => 'decimal:0',
    ];

    // Custom accessor for vou_dt to return date in DD/MM/YYYY format in IST
    public function getVouDtAttribute($value)
    {
        if ($value) {
            return Carbon::parse($value)->timezone('Asia/Kolkata')->format('d/m/Y');
        }
        return null;
    }

    // Relationships
    public function coMaster()
    {
        return $this->belongsTo(CoMaster::class, 'Co_Id', 'Co_Id');
    }

    public function branchM()
    {
        return $this->belongsTo(BranchM::class, 'Br_Id', 'Br_Id');
    }

    public function prtyMast()
    {
        return $this->belongsTo(PrtyMast::class, 'Pr_Id', 'Pr_Id');
    }
}
